package sim.lib.wires;

import java.awt.*;

import sim.*;
import sim.engine.*;
import sim.lib.EditBusSize;

public class FatWire extends Wire
{
/* ==================================================================
	Creation Part
	================================================================= */
	private static Image ICON = GuiFileLink.getImage("sim/lib/wires/BusIcon.gif");
	
	public Image getIcon()
	{
		return FatWire.ICON;
	}
	
	public Wrapper createWrapper()
	{
		return (new FatWire(EssentialModulePanel.BUS_SIZE));
	}
	
	public Wrapper createWrapper(Point gridPosition)
	{
		FatWire result = new FatWire(EssentialModulePanel.BUS_SIZE);
		result.setGridLocation(gridPosition);
		return result;
	}
	
	public String getBubbleHelp()
	{
		return "Bus";
	}
	
/* ==================================================================
	GUI part
	================================================================= */
	public FatWire()
	{
		super();
		
		this.setNumberOfNodes(EssentialModulePanel.BUS_SIZE);
	}
	
	public FatWire(int nodes)
	{
		super();
		
		this.setNumberOfNodes(nodes);
	}

	public void paint(Graphics g)
	{
		// draw if visible
		if(this.isVisible())
		{
			g.setColor(this.brush);
			Dimension size = this.getSize();
			int increment = Wire.THICKNESS / 2 - 1;
		
			if(this.orientation == Wire.HORIZONTAL_ORIENTATION)
				g.fillRect(0, increment, size.width, 3);
			else
				g.fillRect(increment, 0, 3, size.height);
		}
	}

/* ==================================================================
	Wire Responce to Signal
	================================================================= */
	public void respondToUndefined()
	{
	}
	
	public void respondToTrue()
	{
	}
	
	public void respondToFalse()
	{
	}
	
	public void reset()
	{
		this.changeColor(Color.black);
	}
	
/* ==================================================================
	Popup Part for Essentisl Module Panel
	================================================================= */
	public Component getPropertyWindow()
	{
		return (new EditBusSize(EssentialModulePanel.BUS_SIZE));
	}
		
	public void respondToChanges(Component property)
	{
		EssentialModulePanel.BUS_SIZE = ((EditBusSize)property).getBusSize();
	}
}